#include "gmm.h"


typedef struct{
	// GMM Config File
	GMM_Settings * GMMconf;
	// IO L2 arrays
	uint8_t * input_frame;
	uint8_t * output_frame;
	// L3 Pointers 
	uint32_t GMModel;
	struct pi_device *ram;
} pulp_GMM_Operator;

void pulpCV_cl_GMMSubtract(	
	pulp_GMM_Operator * pulpGMMop
);

void pulpCV_fc_GMMInit(
	pulp_GMM_Operator * pulpGMMop,		// GMM configuration structure
	int W_IMG, 					// image width
	int H_IMG, 					// image height
	int hystory, 				// GMM history
	uint8_t Modes, 				// GMM gaussian mode
	struct pi_device *ram 		// ram handler
);

void pulpCV_fc_GMMSubtract(
	pulp_GMM_Operator * pulpGMMop
);
